/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item.custom;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import dev.architectury.registry.fuel.FuelRegistry;
import dev.latvian.mods.kubejs.KubeJSRegistries;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BasicItemJS
extends Item {
    private final Multimap<Attribute, AttributeModifier> attributes;
    private final Multimap<ResourceLocation, AttributeModifier> modifiers;
    private boolean modified = false;
    private final Function<ItemStackJS, Collection<ItemStackJS>> subtypes;

    public BasicItemJS(ItemBuilder p) {
        super(p.createItemProperties());
        if (p.burnTime > 0) {
            FuelRegistry.register((int)p.burnTime, (ItemLike[])new ItemLike[]{this});
        }
        this.subtypes = p.subtypes;
        this.attributes = ArrayListMultimap.create();
        this.modifiers = p.attributes;
    }

    public void m_6787_(CreativeModeTab category, NonNullList<ItemStack> stacks) {
        if (this.subtypes != null) {
            for (ItemStackJS stack : this.subtypes.apply(ItemStackJS.of((Object)this))) {
                stacks.add((Object)stack.getItemStack());
            }
        } else {
            super.m_6787_(category, stacks);
        }
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        if (!this.modified) {
            this.modifiers.forEach((r, m) -> this.attributes.put((Object)((Attribute)KubeJSRegistries.attributes().get(r)), m));
            this.modified = true;
        }
        return slot == EquipmentSlot.MAINHAND ? this.attributes : super.m_7167_(slot);
    }

    public static class Builder
    extends ItemBuilder {
        public Builder(ResourceLocation i) {
            super(i);
        }

        @Override
        public Item createObject() {
            return new BasicItemJS(this);
        }
    }
}

